-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerSource("pointReached")
  self:AddTriggerTarget("activatePoint")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.active = false
    self.pos = self:GetPosition()
    self.p1 = Citadels.GetPlayer(1)
    self.timer = 4
    
    self.pointReached:LinkToTarget("targetCompleted")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      CheckForUnits(self)
      self.timer = 4
    end
  end
end

function OnTrigger(self, source, target)
  if target == "activatePoint" then
    self.active = true
  end
end

function CheckForUnits(self)
  p1units = self.p1:UnitsInRadiusNumber(self.pos, 2000, '*')
  
  if p1units >= 10  then
    self.pointReached:TriggerAllTargets()
    self.active = false
  end
end
